from pycryptopp.cipher.xsalsa import XSalsa
from binascii import hexlify, unhexlify
from nacl import crypto_stream, crypto_stream_xor
from random import randint
import unittest
import os

key = "\x00"*32
iv = "\x00"*24
msg = "\x00"*50

class CompareWithNACL(unittest.TestCase):
    def onetest(self, key, iv, msg):
        expected = hexlify(crypto_stream_xor(msg, iv, key))
        x = XSalsa(key, iv)
        offset = 0
        got = ""
        while offset < len(msg):
            size = randint(1, 50)
            got += hexlify(x.process(msg[offset:offset+size]))
            offset += size
        self.failUnlessEqual(expected, got)

    def test_lots(self):
        for i in range(10000):
            key = os.urandom(32)
            iv = os.urandom(24)
            size = randint(1, 2000)
            msg = os.urandom(size)
            self.onetest(key, iv, msg)

if __name__ == '__main__':
    unittest.main()
