# Note: may be Apache 2.0 license-contaminated.
# (I haven't checked whether there is a significant license compatibility issue here.)

import sys
import windmill
from windmill.bin import admin_lib
from twisted.internet import defer
from foolscap.api import eventually
from allmydata.util import log


class TiltingMixin:
    # adapted from
    # http://github.com/windmill/windmill/blob/master/windmill/authoring/unit.py
    # http://github.com/windmill/windmill/blob/master/windmill/bin/shell_objects.py

    def setUp(self):
        self.browser_debugging = False
        self.settings = {}
        self.configure()

        log.msg("starting gateway")
        self.start_gateway()

        log.msg("setting up Windmill for browser '%s'" % (self.browserName,))
        windmill.block_exit = True
        windmill.stdout = sys.stdout
        windmill.stdin = sys.stdin

        admin_lib.configure_global_settings()
        for (setting, value) in self.settings.iteritems():
            windmill.settings[setting] = value
        windmill.settings['controllers'] = []
        self.shell_objects = admin_lib.setup()

        log.msg("starting browser")
        self.shell_objects['start_' + self.browserName]()

        d = defer.Deferred()
        admin_lib.on_ide_awake.append(lambda: eventually(d.callback, None))
        d.addCallback(lambda ign: log.msg("browser started"))

        if self.browser_debugging:
            self.xmlrpc = windmill.tools.make_xmlrpc_client()
            d.addCallback(lambda ign:
                          self.xmlrpc.add_command({'method':'commands.setOptions',
                                                   'params':{'runTests':False, 'priority':'normal'}}))
        return d

    def tearDown(self):
        windmill.block_exit = False
        if self.browser_debugging:
            self.xmlrpc.add_command({'method':'commands.setOptions',
                                     'params':{'runTests':True, 'priority':'normal'}})
        else:
            log.msg("shutting down browser '%s'" % (self.browserName,))
            admin_lib.teardown(self.shell_objects)
            log.msg("browser shutdown done")
