#!/bin/sh

#BIN="/home/mesh-node/allmydata-tahoe-1.8.2/bin/tahoe"
BIN="/mnt/dev/tahoe-lafs/bin/tahoe"
#BIN="/mnt/dev/tahoe-lafs.git/bin/tahoe"
UPLOAD="/mnt/tahoe-file2upload"
TAHOE_INTRO_DIR="~/.tahoe-intro"
TAHOE_1_DIR="~/.tahoe-1"
TAHOE_2_DIR="~/.tahoe-2"
TMP_DIR="/tmp"
#TEST_TEXT="test download text"
TEST_TEXT="test download text test download text test download text test download text test download text"
NUM_TEST_ROUNDS="1"

# Requirements for this test configuration:
# - tahoe-lafs
# - trickle
# - vnstat
# - TCP Vegas

runtest(){
	TOTAL=0
	#[ -f $TMP_DIR/tahoe-stats-$1.log ] && rm $TMP_DIR/tahoe-stats-$1.log
	date > $TMP_DIR/tahoe-stats-$1.log

	for i in `seq 1 $NUM_TEST_ROUNDS`; do
		[ -f $TMP_DIR/tahoe-file2download ] && rm $TMP_DIR/tahoe-file2download
		/usr/bin/time -o $TMP_DIR/tahoe-stats-$1.log -a -f "%e" $BIN get -d $TAHOE_2_DIR tahoe:tahoe-file2download $TMP_DIR/tahoe-file2download
		[ -z "`grep "$TEST_TEXT" $TMP_DIR/tahoe-file2download`" ] && echo "tahoe get ERROR!" >> $TMP_DIR/tahoe-stats-$1.log
	done
	cat $TMP_DIR/tahoe-stats-$1.log | awk -v ave=0 -v count=$NUM_TEST_ROUNDS '{ ave+=$1; print $1}; END { print "Average: " ave / count }'
}

prepare() {
	# Use TCP Vegas to minimize network latency
	[ -z "`grep "vegas" /proc/sys/net/ipv4/tcp_available_congestion_control`" ] && \
		sudo modprobe tcp_vegas
	[ -z "`grep "vegas" /proc/sys/net/ipv4/tcp_congestion_control`" ] && \
		sudo su -c "echo vegas > /proc/sys/net/ipv4/tcp_congestion_control"

	# Tahoe-1: Storage node
	# Tahoe-2: Gateway node, no storage
	killall tahoe
	$BIN start -d $TAHOE_INTRO_DIR
	$BIN start -d $TAHOE_1_DIR
	$BIN start -d $TAHOE_2_DIR
	sleep 3

	# Prepare and upload the small file which we want to download later
	echo "$TEST_TEXT" > $TMP_DIR/tahoe-file2download2
	$BIN put -d $TAHOE_2_DIR $TMP_DIR/tahoe-file2download2 tahoe:tahoe-file2download
}

vnstatwait() {
	echo "Starting upload. Press enter after you see the speed reaching about 800kbit/s"
	vnstat -i lo -l &
	read FOO
	killall vnstat
}

### Test 0: Download with no parallel upload or limitations
test0() {
	killall tahoe
	$BIN start -d $TAHOE_INTRO_DIR
	$BIN start -d $TAHOE_1_DIR
	$BIN start -d $TAHOE_2_DIR
	sleep 3

	echo "### Running Test 0: Download with no parallel upload or limitations..."
	runtest 0
}

### Test 1: Parallel 'tahoe put', limited to 800kbit/s ###
test1() {
	killall tahoe
	$BIN start -d $TAHOE_INTRO_DIR
	$BIN start -d $TAHOE_1_DIR
	$BIN start -d $TAHOE_2_DIR
	sleep 3

	trickle -s -u 100 -d 100 $BIN put -d $TAHOE_2_DIR $UPLOAD tahoe:tahoe-file2upload 2> /dev/null &
	vnstatwait

	echo "### Running Test 1: Parallel 'tahoe put', limited to 800kbit/s..."
	runtest 1
}

### Test 2: Parallel 'tahoe put', tahoe-2 (gateway) limited to 800kbit/s ###
test2() {
	killall tahoe
	$BIN start -d $TAHOE_INTRO_DIR
	$BIN start -d $TAHOE_1_DIR
	trickle -s -u 100 -d 100 $BIN run -d $TAHOE_2_DIR &
	sleep 3

	$BIN put -d $TAHOE_2_DIR $UPLOAD tahoe:tahoe-file2upload 2> /dev/null &
	vnstatwait

	echo "### Running Test 2: Parallel 'tahoe put', tahoe-2 (gateway) limited to 800kbit/s..."
	runtest 2
}

### Test 3: Parallel 'tahoe put', tahoe-1 (storage) limited to 800kbit/s ###
test3() {
	killall tahoe
	$BIN start -d $TAHOE_INTRO_DIR
	$BIN start -d $TAHOE_2_DIR
	trickle -s -u 100 -d 100 $BIN run -d $TAHOE_1_DIR &
	sleep 3

	$BIN put -d $TAHOE_2_DIR $UPLOAD tahoe:tahoe-file2upload 2> /dev/null &
	vnstatwait

	echo "### Running Test 3: Parallel 'tahoe put', tahoe-1 (storage) limited to 800kbit/s..."
	runtest 3
}


prepare

test0
test1
test2
test3
