import sys

base = "/Users/kacarstensen/Documents/code/tahoe/support/lib/python2.6/site-packages"
sys.path.append(base)

from base64 import b32encode
from test.test_dirnode import FakeClient

class TestProgram:
    def __init__(self):
        self.client = FakeClient()

    def create_directory_tree(self):
        d = self.client.create_empty_dirnode()

        def _create_files(rootdir):
            # Create a small directory tree
            # root/
            # root/file1
            # root/file2
            # root/file3
            self.rootdir = rootdir
            d = rootdir.add_file(u"file1", upload.Data(u'file1', None))
            d.addCallback(lambda res:
                rootdir.add_file(u'file2', upload.Data("bbbb", None)))
            d.addCallback(lambda res:
                rootdir.add_file(u'file3', upload.Data("bbbbc", None)))
            return d

        d.addCallback(_create_files)
        return d

    def get_string(self):
        children = self.rootdir._read()
        def _print_contents(contents):
            packed_contents = self.rootdir._pack_contents(contents)
            print packed_contents

        children.addCallback(_print_contents)
        return children

    def run(self):
        self.create_directory_tree()
        self.get_string()

p = TestProgram()
p.run()
