---
title: Tahoe-LAFS - Nuts & Bolts Meetings

---

# Tahoe-LAFS - Nuts & Bolts Meetings
[Location](https://meet.jit.si/AccurateFiltersManipulateBefore)
[Legacy meeting notes](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/WeeklyMeeting)
[Consolidation of notes](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4104)

## Oct 22, 2024
### Attendees

- Blaise
- Chris
- hacklschorsch
- Meejah


### New Items:
#### Debian build
Is there a set of tools we can use to validate our Debian builds?
#### Decision: let's avoid including Debian-specific dependencies in upstream.


#### Python 3.13
Jeff noticed a weird error with 3.13.rc2: https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4118#comment:4
Chris is checking compatiblity. 3.13 deprecated `cgi` module and there are dependencies on it.
#### Decision: We should move cgi classes to use the Twisted APIs

#### Testing NAT with pytest and libvirt Virtual Networking
@meejah : testing NAT with pytest is a headache
@blaisep : consider one of the networking emulation libraries like [pygmni](https://karneliuk.com/2021/08/pygnmi-10-rapid-and-reliable-network-testing-with-pytest-pygnmi-and-openconfig/)
@chris : `headscale` is a open source tailscale/wireguard to VPN all-the-things (orthogonal, but interesting)
https://archive.fosdem.org/2023/schedule/event/goheadscale/


---

## Oct 15, 2024
### Attendees

- Blaise
- B3n
- Meejah
- Jeff
- Chris


### random notes

- some discussion of security etc around Terraform-managed Gandi DNS 
- some meta-discussion of privacy of data for some use-cases
- distributed forgejo (etc) PRs mentioned, discussed a bit
- blocker: CI not working https://github.com/tahoe-lafs/tahoe-lafs/pull/1377
- Contributor/Developer [step-by-step guide](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4118)
- It would be good to have a good solution for "oops, I merged the wrong commit" scenario. [trac](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4124#ticket)
- Twisted project used https://github.com/chevah/trac-to-github to migrate from trac to github

#### Decisions: 
- convert legacy keywords to static labels
- link to stored queries that contributors can reuse.
- Become independent of [CircleCI](https://sr.ht/~meejah/magic-grid/) is an aspiration. Some brave soul should do it.
- we'll need CircleCI until we can make CI run on the three platforms: Linux, Windows, Mac.
- Look at using [magic grid](https://sr.ht/~meejah/magic-grid/) to automate the tutorials

### [Issue Tracking](https://github.com/tahoe-lafs/MoveOffTrac/blob/main/docs/UserStories.md)
@b3n and @blaisep: Writing the [user stories](https://github.com/tahoe-lafs/MoveOffTrac/blob/main/docs/UserStories.md) for issue tracking revealed some scenarios we had not considered. The team should discuss the alternative and consequences.
We learned:
- There are additional, distinct,  roles with associated privileges and activities.
- Many issues are associated with each other using the free text `keywords` feature, which is not covered by the current migration.
- Ticket Discovery: The View Ticket page has many pre-defined queries which have no direct counterpart outside of trac.

### Related links:
- [Git Federation](https://drewdevault.com/2018/07/23/Git-is-already-distributed.html)
- [Git over ActivityPub](https://forgefed.org/)



### Gaps in the [Contributor guides](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4118)
A new contributor has no clear path to a usable PR. The instructions assume familiarity with the project. For example:
- A contributor cannot find related tickets (WIP, previous solutions, dependencies, @meejah's tutorial automation ticket)
- How to collaborate on tickets that relate to each other?
- CI/CD: Which commands build the project?
- ...It happens that Tox is the the entry point to CI (meejah: not really, but yes tox can run _some_ of the different environments a contributor would want)
- When to use the various Tox targets?
- The instructions for a PR should include everything that a contributor needs for sucessful review (ie. reviewer should not have to run additional tests). (meejah: current best effort here is probably https://github.com/tahoe-lafs/tahoe-lafs/blob/master/CONTRIBUTORS.rst)

### QUESTIONS: current contributor user stories
- As a current contributor, when you want to find a ticket in Trac, do you:
    - Use a prepared query on the [View Ticket](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/ViewTickets) page?
    - Use the Custom query form?
    - Follow links inside an existing issue?



---

## Oct 8, 2024
### Attendees

- Blaise
- B3n
- Chris
- hacklschorsch
- ccx
- Jeffhimself


### New Items


Include tests in the description of an issue.
- https://tahoe-lafs.org/trac/tahoe-lafs/ticket/2050#comment:7

Proposed Docs config changes
    - create
        - docs/test (to store the docs-specific tests)
        - docs/source (to restrict Sphinx to the the docs content, exclude tests, etc.)
    - add sys.path to docs/source/conf.py (to find the source directory)
    - Makefile (run Sphinx against the source directory)
    - Makefile doc-testing (add target for `make doc-testing`)


#### The step-by-step Developer Guide
A failing test(s) for being ready to
- build docs (`tox -e docs` ?)
- run the tests?
- submit a PR (nothing broken that the author couldnt' check themselves)
- build a release

#### Trac migration Developer Experience
- @ccx Search? Associating trac issues to a feature is a PITA (labels, components are migrated)
- @chris: developers should be able to see CI results; what is the integration of issue/commit/PR
- @blaisep : reorder commits to match their tests.
- Codeberg CI https://codeberg.org/Codeberg-CI/woodpecker

### Questions
- How does tox know about the fixtures?
- setup.py install returns:
`error: The 'zope-interface>=5' distribution was not found and is required by Twisted, twisted
` (and I'm not supposed to run setup.py)

---

## Oct 1, 2024
### Attendees

- Blaise
- B3n
- Chris
- hacklschorsch
- Jeffhimself
- Meejah
- Pete

### New Items:

- Release Checklist, simple PR edition?
- Public Grid?
- Public mailbox server? (MagicFolder)
- Fowl and Dilation mentioned as unannounced apps related to file transfers


#### Trac Migration docs
- WIP https://github.com/tahoe-lafs/MoveOffTrac/tree/docs-update-24w40/docs
- Docs tickets will serve as the initial spike to test new user (Blaisep) creation.
- User Account management has some cases we want to excercise (forgot password, account confirmation, etc)
- Redirecting legacy URLs to the new issue tracker.

### Prior Items:

- Debian packaging in progress (@hacklschorsch will ask Debian Tahoe-LAFS maintainer about status, if we can help, and whether/what dependencies are currently missing in Debian)
- fixed cryptography library issue https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4100#no1

#### Dependency management

- "Tahoe is an app, so we shouldn't pin dependencies" @pete

#### related projects
- "Git with you": Peer to Peer git colab (not via github) using pairon (?)
- [Dulwich](https://www.dulwich.io/docs/#getting-started) is a python implementation of git
- https://meejah.ca/blog/wizard-gardens-vision
- [Copybin](https://carml.readthedocs.io/en/latest/command-copybin.html), but private
- https://magic-folder.readthedocs.io/en/latest/invites.html#invites
- Brian's STUN server (?)
- @pete mentioned research on [OCAP](https://github.com/ocapn/ocapn)s over [CRDT](https://github.com/alangibson/awesome-crdt)s
- exposing ssh using [Inlets sshmux](https://inlets.dev/blog/2024/02/05/access-all-your-ssh-servers-with-sshmux.html)
- https://www.wireguard.com/
- [ZCAP](https://w3c-ccg.github.io/zcap-spec/) is separate from Tahoe. [Github]()


---


## Sep 24, 2024
### Attendees

- Blaise
- B3n
- Chris
- hacklschorsch
- Jeffhimself
- Meejah
- Pete

### New Items:

- The new tutorials and docs will default to systemd in examples for running as a service.
- We'll start migrating issues. @b3n will provide a summarized plan next week. If necessary, we'll migrate to a self-hosted forgejo instanc.

#### Migration: User Management topics
- Account creation flow
    - Auto-registration OFF, 
    - User Creation
        - Auto create if Github auth'd
        - Manual 
- Forgotten password flow (eg. Github IdP is down)

#### Tahoe-S3
- A client which maps the finger tree into S3 numbers (and deal with S3 size limits)
- Finger tree used to handle failure scenarios
- Immutables only
- Doesn't create the shares
- Doesn't replace the native Tahoe storage server
- A challenge to implement in Haskell because it requires intimate knowledge of Tahoe internals, REST and Foolscap APIs

#### ADR: Tech stack decisions
- Whither Haskell?
    - How much functionality is already implemented?
    - Haskell is a good high-level language.
- Whither Rust?
    - If we build *low-level* components in Rust, there's opportunity for re-use.
    - Rust has lots of tooling 

#### Improving Immutables
- Single block writers are the problem (@ccx)
- blockless multi-writer implementation is the answer

Speaking of block storage, @blaisep wonders if [k8s longhorn](https://longhorn.io/docs/1.7.1/references/longhorn-client-python/) integration may be a crowd pleaser.


## TILs

- Duplicity has a backend option [`--tahoe`](https://fossies.org/linux/duplicity/duplicity/backends/tahoebackend.py)
- Python pre-compiled for [iOS](https://github.com/PyO3/maturin/issues/1742#issuecomment-1686219705), courtesy of [maturin](https://www.maturin.rs/tutorial)
- Room for improvement in describing our goals, roadmap milestones, features, etc. ("implement Tahoe-S3" vs "have a phone app")


---

## Sep 17, 2024
### Attendees

- Blaise
- B3n
- Pete

### New Items:

#### Trac migration
The time has come. @b3n requests that next week we set in motion the steps to leave trac and use .... something else. (Eventually, we may use GitHub, but before we can migrate to GitHub we need to clean up the issue data anyway).

#### Provisioning and configuration management
On a ddifferent note, most of the meeting was a discussion comparing provisioning and config management tools. @pete has a project where he needs to produce packaged images for various distributions. Ultimately, the images will run containerized applications.
This is an area with too many choices.

Some of the resources that came up in the discussion may be interesting to others:
- [DeBock's Ansible Roles](https://robertdebock.nl/ansible.html#roles). These are tested, [using molecule](https://ansible.readthedocs.io/projects/molecule/), against several Linux distos and versions.
- [Packer](https://www.packer.io/) from HashiCorp, takes the "images as code" approach. Concerns about a terraform-style licensing issue came up.
- [Distrobox](https://distrobox.it/) to create containers with custom configurations.
- [Toolbx](https://containertoolbx.org/) is a wrapper for [podman](https://docs.podman.io/en/latest/) and can be considered as a simpler [alternative to distrobox](https://discussion.fedoraproject.org/t/thread-about-switching-to-distrobox/89151/18?page=2)
- Finally, the consensus is to create a `justfile` using [Just](https://just.systems/man/en/) to control the tasks and invoke tools like packer and ansible when necessary. Also, consider the trick that the [Fedora Atomic Desktop](https://getaurora.dev/) use to alias `ujust` to point to [admin-provided tools](https://universal-blue.discourse.group/t/just-reorganization-part-1-released/417#automation-and-scripting-3).
- We agreed that [dagger engine](https://docs.dagger.io/quickstart/#topics) would be useful for interacting with the running containers, but this was out of scope.

---

## Sep 10, 2024
### Attendees

- Blaise
- hacklschorsch
- Chris
- Ccx

### Step-by-step approach to getting started
Instead of [showing everything at once](https://imgflip.com/i/930yve), build up the service one feature at a time. @blaisep  has Incoming PR for https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4103


### Express modularity using C4 notation for the diagrams
- layers of abstraction Context, Container, Component, Code
- [PlantUML includes](https://crashedmind.github.io/PlantUMLHitchhikersGuide/) C4 in the std lib
- https://crashedmind.github.io/PlantUMLHitchhikersGuide/C4/C4Stdlib.html

### Describing Tahoe to local user groups
As prep for presenting to larger conferences
@blaisep offers to do user group talks (later: conference presentations)
- Historical context (eg. why did they create SDK first? Surveillance capitalism, enshitification, etc.)
- Use case examples (creating examples relevant to end users)
    - The "dumb pipe scenario" (provider-independent security), use cloud storage for personal data. 
    - Storage only is low value

#### Challenges
Either gaps in functionality or gaps in understanding
- Describing the security boundaries (eg.vs corp walled gardens)
- Key management, rotattion, revocation
- The "dumb pipe scenario" (provider-independent security), use cloud storage for personal data. 
- No generic writer( @ccx ) can't write everything to/from everywhere.

#### Comparisons
Describing Tahoe in terms of something they already know.
- Nostr:  @chris has written some [Nostr](https://nostr.org/) bots. It's not a dumb pipe in a security sense. It's meant to be censorship-resistance, not confidentiality. More of a brute force approach vs lots of cryptography. @hacklschorsch liked the way the Nostr delivery model (push data to your favorite relay...) is presented.
Flo said NIP-104 will be a big improvement for private messaging 
https://github.com/nostr-protocol/nips/pull/1427
 
- IPFS: similar layer of abstraction. More client implementations. Scales differently? https://news.ycombinator.com/item?id=37750529
- Signal: but for storage ( _can Signal self host?_ ) The reference implementation is a useful app, SDKs, Open protocol, ubiquitous.
- Syncthing: (peer-to-peer) but with decentralization and capabilities (@ccx)

---

## Sep 3, 2024
### Attendees

- b3n
- Blaise
- hacklschorsch
- Meejah
- Ccx


## Prior Items

- Glossary items

- Debian packaging maybe delayed because `pycddl` has never been packaged for Debian. We might make it in by the end of the year. @hacklschorsch 
    - (we should check if any of our other dependencies have never been packaged for Debian @meejah)

- Trac migration (see: https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac#ProsandConsofself-hostedvsSaaS) looking at the results of migration, @b3n noticed a number of issues with author attribution and broken reference links.
  - @b3n suggests that we consider a transition period where we run selfhosted and collaborate on the issues we care to migrate. (eg. the user creation needs to be automatic, yet if we set it to auto, then we also get junk accounts created) We can choose a threshold of noise and migrate or wait until it is perfect.
  - "Our trac instance has defferred maintenance and accummulated cruft over the years. The community wants to retain the option to selfhost, even if we choose not to. So if it makes sense to self host, then we can exercise that option." @meejah

- @hacklschorsch: Can we lower the Tahoe-LAFS merge process turnaround time?
  - Optimistic Merging / other ideas for the Tahoe-LAFS GitHub repo? to make contributing leaner/more fun
  - meejah: A PR that is green and has approvals is already merged quickly now.  If not, write on IRC
  - Currently, meejah is the only active committer in Tahoe-LAFS.  The committers agree it would be good to have more committers, but it's not an easy task. Blaise nominates ccx, but ccx does not have time right now.


## New items

- Veilid: is it real, where are the intersections?

@ccx : it's a library which bundles a number of p2p protocols. No existing app yet.

@meejah : played with ethersync and he made it do a thing. It's early and doesn't do anything yet. For instance, no one would install MagicWormhole if they couldn't do file sharing.

### Making it easier to develop on Tahoe
Separation of concerns, breaking tahoe into modules would be a good next move. @ccx (@blaise start a trac issue?)

---

## August 27, 2024
### Attendees

- b3n
- Chris
- hacklschorsch
- Meejah
- Pete

### Updates

- Flo
  - LA wants to hire a senior Haskeller to work on LAFS
  - iOS: Obsidian is still investigating the "illegal instruction" compiler/linker issue
  - Wrote some eMails back and forth with the Debian Tahoe-LAFS maintainer: Would be great if 1.20 would be clean of Python 2 code so it can be included in Debian again.  Also need to look at Debian Trixie code freeze date
  - Works with Blaise on Tahoe-LAFS docs
  - ... and would like to pair more in general
 
- Chris
  - published a Rust crate for LAFS: https://crates.io/crates/lafs  
 source repo: https://github.com/crwood/lafs
  -  Local and much faster than the Python equivalent (.25s instead of 24s on Chris' machine)
  -  It comes with Python bindings

- b3n
  - Codeberg importing issue acknowledged by them
  - Would like to discuss self-host vs. SaaS for the upcoming GitTea with Meejah

- Meejah
  - Magic Wormhole protocol work
  - FOWL Policy & Permissions API mostly done, soon to be merged & released.
  - [Pear-On](https://sr.ht/~meejah/pear-on/) should work ATM - testers welcome


## Previous items

@blaisep Now owns [17 trac tickets from the backlog](https://tahoe-lafs.org/trac/tahoe-lafs/query?owner=blaisep&status=assigned&status=new&status=reopened&id=&keywords=~&reporter=~&col=id&col=summary&col=keywords&col=reporter&col=status&col=owner&col=type&col=priority&col=milestone&col=changetime&desc=1&order=id) which are addressed in this month's effort to produce the getting started kit (docs and Artifacts)


## New Items

- Trac [#4103](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4103#ticket) is a running summary of the items related to the Getting started guide.
- Trac [4102](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4102#ticket) describes a workaround for a problem with one of the transitive dependencies (`eliotutils.py`).
- @blaisep has limited availability until Sep 30 2024


---

## August 20, 2024
### Attendees

Blaise
b3n
ccx
Chris
hacklschorsch

## Previous items

### WTF Circle CI?
* Is it broken? Maybe drop it?
* Do we have much logic in the Circle CI?
* It might be tests failing, rather than a systemic fail (credentials, dependencies, etc)
* "AMP server"? (twisted RPC framework) @ccx
* * https://app.circleci.com/pipelines/github/tahoe-lafs/tahoe-lafs/4958/workflows/d16324ae-293d-45c8-ba97-6ac39ef4cfc4
* https://app.circleci.com/pipelines/github/tahoe-lafs/tahoe-lafs/4958/workflows/d16324ae-293d-45c8-ba97-6ac39ef4cfc4/jobs/86344


### Towards a portable CI
* keep logic in the repo
* avoid huge Nix dependency (or maybe build a weekly Nix image)
* https://docs.gitlab.com/ee/ci/ci_cd_for_external_repos/github_integration.html



### Describe the build process
* add prose in the dev guide to the files in the repo describing the build (@blaise)
* update the release checklist: https://tahoe-lafs.readthedocs.io/en/latest/release-checklist.html

### Mutables, Service of Happiness
* @blaise asked where we were at with mutables...
* using mutables as single writers (eg. Tahoe backup)
* It's a big thing, eventually replace with a proper design for a multi-writer primitive
* For now, stick with readonly or Magic Folder for examples and getting started guide.
* > Mutables are not just even single-writer safe because partitions can cause rollbacks. Shouldn't be super common but it's still real world error case. @ccx

### [MoveOffTrac](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac) - [#4095](https://tahoe-lafs.org/trac/tahoe-lafs/ticket/4095)
* Trac dump from last month has been migrated on the self-hosted Forgejo [instance](https://forge.lafs.eval.latfa.net/tahoe-lafs/trac-2024-07-25).
* Working on user mapping: trying to figure how to link trac users to Gitea/Forgejo users, with a mapping to the Github user if different!
* New Forgejo instance (copy/paste from Gitea) to be closer to Codeberg: https://forge.lafs.eval.latfa.net/tahoe-lafs/
* Testing migration to Codeberg with pagination bug (workaround), performance issue (deadlock error) and user mapping (unlikely possible)
* Keyoxide.org may help us to link all those account!?

## New Items 

* Blaisep has trac !!!
* TIL: Trac use "htdigest" (@meejah "i'll put a note in ~trac")

---

## August 13, 2024
### Attendees

Blaise
b3n
ccx
Chris
hacklschorsch
Pete

## Previous items

- Blaise needs a trac account to CRUD issues, for docs, etc.
- GitTea self register results in many spam accounts @b3n
- We have users on Trac and users on GitHub, sometimes the names are different. @b3n
- Trac Migration Plan [WIP](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/MoveOffTrac)
- migrated Trac eval instance (https://code.lafs.eval.latfa.net/tahoe-lafs/trac-2024-05-23/issues)

## New
- Meejah might not have admin to [github.com/tahoe-lafs](https://github.com/tahoe-lafs/tahoe-lafs/pull/1370) but so far that isn't yet a problem (eg. if Circle CI creds need updating.) @blaisep 
- Consider using Google, GitHub auth for auto register CodeBerg accounts
- Consider upgrading/self hosting Trac instance (maybe it's not so bad after all) 
- Could we make trac readonly and do new work on the ["demo" instance](https://www.lafs.eval.latfa.net/) instance? 


### Migrating Issues: Goals and Constraints
- Anything off of track is better
- Github Issues are accessible, but there is risk of lock-in, enshitification
- Gitea/Forgejo/CodeBerg is future-proof (no lock-in)
- Inconsistent tribal knowledge about decisions made last year @blaisep et al.

---


## August 6, 2024
### Attendees

Blaise
b3n
Chris
ccx
hacklschorsch
meejah
Pete


Thought leaders:
Amber O'Hearn (not so much)
Larry Lessig
Brewster Kahle
Christine_Lemmer-Webber (spritely)


New Items:

Pete's foundation doc: https://docs.google.com/document/d/1MpFUUB9sX-SA6rsHpq9ZkIhrnZaG3zwzI6KJ9I0VAgE/edit

## Comparables

* https://spritely.institute/about/
* https://ocapn.org/
* https://darkcrystal.pw/ (meejah)
* ISRG https://www.abetterinternet.org/
* https://divviup.org/
* https://sans-io.readthedocs.io/


### Mission statements

"Infrastructure for Libre, gratis, private, intentional composability and sharing " @Blaise , @meejah

Device introduction @meejah

"social infrastructure tools (sharing and composability to support differrent social structures and relationships)" 
Bootstrap social relations, dependency maps.
@Chris

secure sharing with least privilege (zero trust?) @ccx
(Higher resolution, more ephemeral than app-level privs)
https://roy.marples.name/blog/posts/capsicum_vs_pledge_final_thoughts

Discoverable, "~~decentralized~~" (Autonomous?) / disconnected in nature (eg. TLS without the PKI) @Pete
Provider independent


### Community Survey

@Chris: Maybe do a poll "Should we build a Library or an application?" Right now it's the worst of both worlds. Maybe we could explore where we could get more bang; decompose into smaller building blocks may be better.
eg, decouple wire protocol from the U I.
https://sans-io.readthedocs.io/ @Pete 

Who is the audience? grandmas with photosharing? Political activists? crypto bros?

---

## July 30, 2024
### Attendees

Blaise
hacklschorsch
b3n
Chris
Pete
ccx

## Highlights:
* Project governance structure

## Agenda

### Previous topics:

* Docs PR in progress

## New Topics:
* A proposal for a governance structure (Pete)

### An endowment and governance structure

* Align the Tahoe mission with the right institutional structure.
* Similar cases:
    * The [Veillid Foundation](https://veilid.org/about-us/) is a very close analog.
    * https://www.djangoproject.com/foundation/
    * https://foundation.mozilla.org/en/who-we-are/
    * https://www.abetterinternet.org/documents/2023-ISRG-Annual-Report.pdf
    * https://www.abetterinternet.org/about/
    * https://matrix.org/foundation/about/
* Fund some dedicated project support

### Who is the community?
* Board members
* What are the activities?
* Intellectual property portfolio (trademarks, copyrights, patents)?

### Who is NOT the community?
Where has the project stalled and why?
Why do people drop in, get frustrated, and leave?
What are the blockers for adoption and how can we overcome them.

### Tahoe public resources; what could we build next?
* Public test grid ?
* ZCap servers ?

#### Other options for funding services

* https://docs.opencollective.foundation/how-it-works/fees

#### Dependent projects
GridSync (golang) ?
Magic Wormhole ?

#### Dependencies
* Twisted
* Mutables
* Python https://meta.pycqa.org/introduction.html

---

## July 23, 2024

### Attendees

Blaise
hacklschorsch
Meejah
b3n
Chris
ccx


## Highlights:
* Mutables would be a good thing for the Foundation to fund.
* The goal of [GBS](https://gitlab.com/tahoe-lafs/gbs-downloader) is to replace foolscap. Not there yet. (sucks to require a node online)
* Create project for client filesystem

## Agenda

### Previous topics:

Meejah: 
* Trac disk space restored
* Granted admin privs

hacklschorsch:
Mobile LAFS [Wiki page](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/TahoeLAFSMobile) with draft description of Features and Scope.

B3n: 
Next, Trac migration path (DNS, )
Codeberg bug


### New topics:
* B3n: Prepare Trac migration operating instructions (DNS settings, etc)
* B3n: Help Meejah create Trac account (for Blaise).
* Decision: Let's try to make the single mobile code base work (hacklschorsch)
* Deep integration with the OS is not MVP  (hacklschorsch)
* [Gitlab milestones](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/milestones/7#tab-issues) don't have the OS integration yet.(ccx)
* Create FUSE module for the dev environment (ccx)

## Notes:

Chris: 
* [Porting Tahoe hashlib](https://github.com/crwood/deterministic-keygen/issues/5) to Rust and found an issue:
* To do a restore with user supplied keys, if a directory is already created we get an uncoordinated error. Possible solution is to derive the cap locally.
* Curating a common set of test vectors

#### Restore scenarios
Todo: write up a description, describing permuted scenarios (Meejah, Chris)
(We need better words to describe the operations and events)

Four scenarios:
* Client failed, grid is fine
* Grid loses nodes
* Grid loses partial data
* Grid loses all data


#### Mutables
* Don't do service happiness (ccx's complaint)

Can't detect all the restore scenarios. Sometimes all the shares end up on one server :frowning: 
What is the meaning of Happiness? Happiness is just a number (Meejah)

#### Mobile
* Need to write up the description in  [Wiki page](https://tahoe-lafs.org/trac/tahoe-lafs/wiki/TahoeLAFSMobile) 
* We need to describe how much of the functionality
* Foolscap requires a node online, [GBS](https://gitlab.com/tahoe-lafs/gbs-downloader) does not
* "User defined grid" ? (ccx)
* What if we had a gridsync client (b3n)
* Deep integration with the OS is not MVP  (hacklschorsch)
* Obsidian has something called `backend` which is different.
* [Obelisk overrides](https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/blob/main/obelisk/haskell-overrides.nix?ref_type=heads)
* Let's have good interface definitions (ccx)
* [Gitlab repo](https://gitlab.com/tahoe-lafs/tahoe-great-black-swamp) Code 


#### File system browser? (ccx)
* Can we use the native [mobile libraries](https://emanual.github.io/Android-docs/guide/topics/providers/document-provider.html)?
* How much do we need in the GUI?
* (https://gitlab.com/tahoe-lafs/tahoe-lafs-mobile/-/blob/main/obelisk/haskell-overrides.nix?ref_type=heads)

#### Create project: Investigate FUSE File System Support (ccx)
* Read/Only native client
* Read/Only magic folder
* Read/Write Magic Folder
* Built on top of GBS downloader

---



