#! /bin/sh
# This script repeats its arguments until failure.  stderr/out of the failed/terminating run is stored in ${OUTNAME}.log which can be set as an argument to -o. `time` for each run is logged in ${OUTNAME}_times.log.   For convenient testing uncomment THRESH and associated test.  
OUTNAME=$1"_repeater"
if getopts "o:" OUTPUT; then
    OUTNAME=${OPTARG};
fi
let OPTIND=${OPTIND}-1
shift ${OPTIND}
touch INDICATOR;
while [ -f INDICATOR ];
do
    (time if !($* > ${OUTNAME}.log 2>&1 );then mv INDICATOR INDICATOR_NEG;fi) 2>> ${OUTNAME}_times.log;
    #THRESH=1000;
    #if [[ ${RANDOM} -lt ${THRESH} ]];then mv INDICATOR INDICATOR_NEG;fi
done
