#!/usr/bin/python

import unittest
from mock import Mock, patch, sentinel

from allmydata.introducer.client import IntroducerClient
from allmydata.client import Client, MULTI_INTRODUCERS_CFG


class TestClient(unittest.TestCase):
    
    def setUp(self):        
        pass
        # set-up two introducers and few clients
        
    def tearDown(self):
        pass
        # shut-down introducers and clients

    @patch('allmydata.introducer.client.IntroducerClient')
    def test_introducer_clients_count(self, MockIntroducerClient):
        MockIntroducerClient.return_value = sentinel.IntroducerClient
        
        # See how many introducers are listed in "introducers" cfgfile
        furls = 1 # default introducer_furl from tahoe.cfg
        f = open(MULTI_INTRODUCERS_CFG, 'r')
        for introducer_furl in  f.read().split('\n'):
                if not introducer_furl.strip():
                    continue
                furls += 1
        f.close()
        
        # get a client and count of introducer_clients
        myclient = Client()
        ic_count = len(myclient.introducer_clients)

        self.assertEquals(furls, ic_count)

if __name__ == "__main__":
    unittest.main()
