#!/usr/bin/python

import unittest
from mock import Mock, patch, sentinel

from allmydata.web.root import Root
from allmydata.client import Client

class TestRoot(unittest.TestCase):
    
    @patch('allmydata.web.root.Root')
    def test_introducer_furls(self, MockRoot):        
        # items needed to call data_introducer_furl()
        mockctx = Mock()
        mockdata = Mock()  
        myclient = Client() # Mock() can be set
        # prepare expected return value: 
        # sentinel.introducer_furl can be set as value
        ifurl = "pb://7qohn4uiyfpw3xlwg5xavo5mmxfz6eap@192.168.1.3:40338,127.0.0.1:40338/introducer"
        myclient.introducer_furl = ifurl
            
        # Pass mock value to Root
        myroot = Root(myclient)
        
        # make the call
        furl = myroot.data_introducer_furl(mockctx, mockdata)

        
        #assertions: compare return value with preset value
        self.assertEquals(furl, ifurl )  

if __name__ == "__main__":
    unittest.main()
